#ifndef QRFESERIALPORT_H_
#define QRFESERIALPORT_H_

#include <QSerialPort>
#include <QSerialPortInfo>

#define QrfeSerialPort		QSerialPort
#define QrfeSerialPortInfo	QSerialPortInfo

Q_DECLARE_METATYPE(QrfeSerialPortInfo)


#define BAUD50          QSerialPort::Baud50
#define BAUD75          QSerialPort::Baud75
#define BAUD110         QSerialPort::Baud110
#define BAUD134         QSerialPort::Baud134
#define BAUD150         QSerialPort::Baud150
#define BAUD200         QSerialPort::Baud200
#define BAUD300         QSerialPort::Baud300
#define BAUD600         QSerialPort::Baud600
#define BAUD1200        QSerialPort::Baud1200
#define BAUD1800        QSerialPort::Baud1800
#define BAUD2400        QSerialPort::Baud2400
#define BAUD4800        QSerialPort::Baud4800
#define BAUD9600        QSerialPort::Baud9600
#define BAUD14400       QSerialPort::Baud14400
#define BAUD19200       QSerialPort::Baud19200
#define BAUD38400       QSerialPort::Baud38400
#define BAUD56000       QSerialPort::Baud56000
#define BAUD57600       QSerialPort::Baud57600
#define BAUD76800       QSerialPort::Baud76800
#define BAUD115200      QSerialPort::Baud115200
#define BAUD128000      QSerialPort::Baud128000
#define BAUD256000      QSerialPort::Baud256000

#define DATA_5          QSerialPort::Data5
#define DATA_6          QSerialPort::Data6
#define DATA_7          QSerialPort::Data7
#define DATA_8          QSerialPort::Data8

#define PAR_NONE        QSerialPort::NoParity
#define PAR_ODD         QSerialPort::OddParity
#define PAR_EVEN        QSerialPort::EvenParity
#define PAR_MARK        QSerialPort::MarkParity
#define PAR_SPACE       QSerialPort::SpaceParity

#define STOP_1          QSerialPort::OneStop
#define STOP_1_5        QSerialPort::OneAndHalfStop
#define STOP_2          QSerialPort::TwoStop

#define FLOW_OFF        QSerialPort::NoFlowControl
#define FLOW_HARDWARE   QSerialPort::HardwareControl
#define FLOW_XONXOFF    QSerialPort::SoftwareControl


#endif /*QRFESERIALPORT_H_*/
